# coding: iso-8859-1


class Project_XP < Project




  Pm_Info = Struct.new("Pm_Info", :width, :height, :nb_ligne, :nb_mot, :nb_message)

  Pm_Rapport = Struct.new("Pm_Rapport", 
    :nb_map,
    :nb_tile_tot, :nb_tile_moy,
    :superficie_tot, :superficie_moy,
    :nb_ligne_tot, :nb_ligne_moy,
    :nb_mot_tot, :nb_mot_moy,
    :nb_message_tot, :nb_message_moy
  )

  def creer_pourcentage_maker

    a = Time.new


    liste = lister_dmk
    liste.keep_reg!(R_MAP_DMK)


    putss "#92 Rcupration des infos du projet."

    liste_infos = []
    for i in 0...liste.size
      nom_map = liste[i]
      puts nom_map.basename
      file_dmk = charger_dmk(nom_map)
      pm_recuperer_infos(liste_infos, file_dmk)

    end

    t = Time.new-a
    putss "#57 Infos de %d fichiers rcupres en %.02f secondes.", liste.size, t

    putss "#101 Traitement des donnes"
    rapport = pm_traiter_donnees(liste_infos)

    path = self.dossier_local(F_POURCENT)

    pm_ecrire_rapport(path, rapport)

    pause

  end


  def pm_recuperer_infos(liste, map)

    width = map.width.to_i
    height = map.height.to_i

    #p width, height

    # Infos en rapport avec les messages
    nb_ligne, nb_mot, nb_message = pm_recuperer_infos_message(map)


    info = Pm_Info.new(width, height, nb_ligne, nb_mot, nb_message)
    liste.push(info)

  end



  def pm_recuperer_infos_message(map)

    codes = [101, 401, 402]
    map_instruction = map.recuperer_code_objet(codes)

    # Le nombre total de lignes de dialogues
    nb_ligne = map_instruction.instructions.size

    nb_message = 0

    # On rcupre tous les textes
    txt = ""
    for instruction in map_instruction.instructions
      instr = instruction.instruction
      txt << instr.get_message+" "
      nb_message += 1 if instr.code == 101
    end

    # On tudie les mots
    nb_mot = pm_recuperer_infos_texte(txt)

    #puts txt

    return nb_ligne, nb_mot, nb_message

  end


  def pm_recuperer_infos_texte(txt)

    # On mets les lettres au format anglais
=begin
    txt.gsub!(//, "a")
    txt.gsub!(//, "e")
    txt.gsub!(//, "i")
    txt.gsub!(//, "o")
    txt.gsub!(//, "u")
    txt.gsub!(//, "y")
    txt.gsub!(//, "c")
=end
    
    #txt.gsub!(Regexp.new("\303\251\303\250\303\252\303\253"), "e")
    txt.gsub!(/\303\251|\303\250|\303\252|\303\253/, "e")
    txt.gsub!(/\303\254|\303\256|\303\257/, "i")
    txt.gsub!(/\303\262|\303\264|\303\266/, "o")
    txt.gsub!(/\303\271|\303\273|\303\274/, "u")
    txt.gsub!(/\303\277/, "y")
    txt.gsub!(/\303\247/, "c")


    # On enlve tous les symboles et caractres
    #reg = /\\\w\[\d+\]|[\W\D]/i
    #reg = /[\W\d]/
    reg = /\\\w\[\d+\]|[\W\d]/

    txt.gsub!(reg, " ")

    lst = txt.split(" ")
    nb_mot = lst.size

    #puts txt
    return nb_mot
  end


  def pm_traiter_donnees(liste_infos)
    superficies = []

    nb_map = liste_infos.size

    nb_ligne_tot = 0
    nb_mot_tot = 0
    nb_message_tot = 0
    
    for map in liste_infos
      superficies.push(map.width*map.height)
      nb_ligne_tot += map.nb_ligne
      nb_mot_tot += map.nb_mot
      nb_message_tot += map.nb_message
    end
    sum = superficies.sum
    avg = superficies.avg

    nb_tile_tot = sum
    nb_tile_moy = avg

    superficie_tot = nb_tile_tot*32*32
    superficie_moy = nb_tile_moy*32*32

    nb_ligne_moy = nb_ligne_tot.to_f/nb_map
    nb_mot_moy = nb_mot_tot.to_f/nb_map

    nb_message_moy = nb_mot_tot.to_f/nb_message_tot

    rapport = Pm_Rapport.new(
      nb_map,
      nb_tile_tot, nb_tile_moy,
      superficie_tot, superficie_moy,
      nb_ligne_tot, nb_ligne_moy,
      nb_mot_tot, nb_mot_moy,
      nb_message_tot, nb_message_moy
    )

    
    rapport.each_with_index{|attr, i|
      rapport[i] = attr.to_s3
    }

    return rapport

  end


  def pm_ecrire_rapport(path, rapport)

    putss "#45 Ecriture du rapport dans le fichier suivant : %s", path

    
    #pays = traduire("#slovaque, tchtchne, russe, danoise, ouzbkistanaise, palestinienne, amricaine, hongroise, finlandaise, portugaise, espagnole, franaise, suisse, brsilienne, africaine, chinoise, corenne, belge, inuit, basque, mongasque")
    #liste_pays = pays.gsub!(" ", "")
    #liste_pays = liste_pays.split(",")
    #pays = liste_pays[rand(liste_pays.size)]

    phrase_finale = traduire("#50 Estimation Pourcentage Maker :")


    pourcentage = rand(100+1-10)+10

    lignes = []

    lignes << traduire("#96 Statistiques sur les maps")

    lignes << ""
    lignes << traduire("#76 Nombre de maps : %d maps", rapport.nb_map)
    lignes << ""

    lignes << traduire("#98 Superficie totale des maps :") +  traduire("#27 %s tiles", rapport.nb_tile_tot)+"  =>  "+traduire("#24 %s pixels", rapport.superficie_tot)
    lignes << traduire("#97 Superficie moyenne des maps :") +  traduire("#27 %s tiles", rapport.nb_tile_moy)+"  =>  "+traduire("#25 %s pixels carr", rapport.superficie_moy)
    lignes << traduire("#79 Nombre total de lignes de dialogue :") +  traduire("#6 %s lignes", rapport.nb_ligne_tot)+"  =>  "+traduire("#8 %s mots", rapport.nb_mot_tot)
    lignes << traduire("#77 Nombre moyen de lignes de dialogue :") +  traduire("#6 %s lignes", rapport.nb_ligne_moy)+"  =>  "+traduire("#8 %s mots", rapport.nb_mot_moy)
    lignes << traduire("#80 Nombre total de messages :") +  traduire("#7 %s messages", rapport.nb_message_tot)
    lignes << traduire("#78 Nombre moyen de mots par message :") +  traduire("#9 %s mots par message", rapport.nb_message_moy)
    

    lignes << ""
    lignes << ""
    lignes << "-------------------"
    lignes << ""
    lignes << phrase_finale
    lignes << ""

    lignes << traduire("#105 Votre jeu semble tre fini ... %d %%.", pourcentage)

    total = lignes.join("\n")

    DA::file_write(path, total)
    
  end


end